//  
//  WebCmds.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.


using System;
using System.Text;
using System.Collections;
using System.Threading;
using System.IO;
using System.Net;
using System.Net.Cache;
using System.Reflection;
using Configurator;



namespace LapperThreads
{
    public class webCmd
    {
        public int UCID;
        public string url;
        public webCmd(int UCID, string url )
        {
            this.UCID = UCID;
            this.url = url;
        }
    }
    public class webReturn
    {
        public int UCID;
        public string WebRet;
        public webReturn(int UCID, string webRet)
        {
            this.UCID = UCID;
            this.WebRet = webRet;
        }
    }

    public class WebCmds
    {
        public Hashtable listOfUserPB = new Hashtable();
        public Queue QwebCmd = new Queue(100);
        public Queue QwebReturn = new Queue(100);
        private GLDebug.Debug myDebug;
        private string PubStatIdk = "";
        public WebCmds(GLDebug.Debug pmyDebug, string pPubStatIdk)
        {
            this.myDebug = pmyDebug;
            this.PubStatIdk = pPubStatIdk;
        }
        public void TWebCmds()
        {
            myDebug.WriteLine("mss","Web Commands Thread Started...");
            while (true)
            {
// Web request
                Monitor.Enter(QwebCmd);
                if (QwebCmd.Count != 0)
                {
                    
                    webCmd cmd = (webCmd)QwebCmd.Dequeue();
                    Monitor.Exit(QwebCmd);
                    queryWebCmd(cmd);
                }
                else
                {
                    Monitor.Exit(QwebCmd);
                }
                System.Threading.Thread.Sleep(100);
            }
        }

        private void queryWebCmd(webCmd cmd )
        {
            try
            {
                string readLine = "";
                //Console.WriteLine(cmd.url);
                WebRequest req = WebRequest.Create(cmd.url);
                req.Timeout = (int)LFSLapper.paramLapper.webTimeOut;

                RequestCachePolicy policy = new RequestCachePolicy(RequestCacheLevel.NoCacheNoStore);
                //                    req.CachePolicy = policy;

                WebResponse result = req.GetResponse();
                Stream receiveStream = result.GetResponseStream();
                using (StreamReader sr = new StreamReader(receiveStream))
                {
                    readLine = sr.ReadToEnd();
                    //Console.Write(readLine);
                    Monitor.Enter(QwebReturn);
                    QwebReturn.Enqueue(new webReturn(cmd.UCID, readLine));
                    Monitor.Exit(QwebReturn);

                }
            }
            catch
            {
                myDebug.WriteLine("err", "Error on receiving answer from web");
            }

        }
        public void sendWebCmd(int UCID, string url)
        {
            Monitor.Enter(QwebCmd);
            QwebCmd.Enqueue(new webCmd(UCID, url));
            Monitor.Exit(QwebCmd);
        }
        public webReturn getWebReturn()
        {
            Monitor.Enter(QwebReturn);
            if (QwebReturn.Count == 0)
            {
                Monitor.Exit(QwebReturn);
                return null;
            }
            webReturn retValue = (webReturn)QwebReturn.Dequeue();
            Monitor.Exit(QwebReturn);
            return retValue;            
        }
    }
}
